<!DOCTYPE html>
<html lang="ja">
	<head>
		<meta charset="UTF-8">
		<title></title>
		<!--meta-->
		<meta name="viewport" content="width=device-width" />
		<!--stylesheet-->
		<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" media="all">
		<link href="https://fonts.googleapis.com/css?family=Crimson+Text|Kosugi+Maru|Roboto+Condensed&display=swap" rel="stylesheet">
		<!--[if lt IE 9]>
		<script src="https://ie7-js.googlecode.com/svn/version/2.1(beta4)/IE9.js"></script>
		<script src="https://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
		<script src="https://html5shim.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->
		<!-- Google Tag Manager -->
			<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
			new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
			j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
			'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
			})(window,document,'script','dataLayer','GTM-WSXQWHB');</script>
		<!-- End Google Tag Manager -->
		<?php wp_head(); ?>
	</head>
	<body id="body" <?php body_class(); ?>>
		<!-- Google Tag Manager (noscript) -->
			<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WSXQWHB"
			height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
		<!-- End Google Tag Manager (noscript) -->
		<header class="ja">
			<div id="header_content" class="ja">
				<a id="header_logo" href="<?php echo home_url('/'); ?>#top">
					<figure>
						<img src="<?php bloginfo('template_url'); ?>/images/header/header_logo.png" alt="">
					</figure>
				</a>
				<figure id="menu_button" class="ja">
					<svg class="hamburger" width="26px" height="25px" viewBox="0 0 26 18">
						<path class="hamburger-01" d="M25.5,2H1A1,1,0,0,1,1,0H25.5a1,1,0,0,1,0,2Z"></path>
						<path class="hamburger-02" d="M25.5,10.07H1a1,1,0,1,1,0-2H25.5a1,1,0,1,1,0,2Z"></path>
						<path class="hamburger-03" d="M25.5,18.14H1a1,1,0,0,1,0-2H25.5a1,1,0,0,1,0,2Z"></path>
					</svg>
				</figure>
				<div class="pc">
					<div id="header_btn">
						<div class="btn_sitemap">
							<a class="solid_1 corner_5" href="<?php echo home_url('/'); ?>sitemap">
								Sitemap
							</a>
						</div>
						<!--<div id="btn_language">
							<a class="solid_1 corner_5" href="<?php echo home_url('/'); ?>en">
								ENGLISH
							</a>
						</div>-->
					</div>	
					<nav id="header_menu_ja">
						<?php wp_nav_menu(array(
							'sort_column' => 'menu_order',
							'theme_location' => 'globalNavi',
							'container' => '',
						)); ?>
					</nav>
				</div>
				<nav id="header_menu_ja" class="sp">
					<?php wp_nav_menu(array(
						'sort_column' => 'menu_order',
						'theme_location' => 'globalNavi_sp',
						'container' => '',
						'menu_id' => 'mobile_header_menu_ja',
						'menu_class' => 'menu ja'
					)); ?>
				</nav>
			</div>
		</header>
		<header class="en">
			<div id="header_content" class="en">
				<a id="header_logo" href="<?php echo home_url('/en'); ?>#top">
					<figure>
						<img src="<?php bloginfo('template_url'); ?>/images/header/header_logo.png" alt="">
					</figure>
				</a>
				<figure id="menu_button" class="en">
					<svg class="hamburger" width="26px" height="25px" viewBox="0 0 26 18">
						<path class="hamburger-01" d="M25.5,2H1A1,1,0,0,1,1,0H25.5a1,1,0,0,1,0,2Z"></path>
						<path class="hamburger-02" d="M25.5,10.07H1a1,1,0,1,1,0-2H25.5a1,1,0,1,1,0,2Z"></path>
						<path class="hamburger-03" d="M25.5,18.14H1a1,1,0,0,1,0-2H25.5a1,1,0,0,1,0,2Z"></path>
					</svg>
				</figure>
				<div id="header_right" class="pc">
					<div id="header_btn">
						<div class="btn_sitemap">
							<a class="solid_1 corner_5" href="<?php echo home_url('/'); ?>sitemap">
								Sitemap
							</a>
						</div>
						<div id="btn_language">
							<a class="solid_1 corner_5" href="<?php echo get_permalink(6); ?>">
								JAPANESE
							</a>
						</div>
					</div>	
					<nav id="header_menu_en">
						<?php wp_nav_menu(array(
							'sort_column' => 'menu_order',
							'theme_location' => 'globalNavi_en',
							'container' => ''
						)); ?>
					</nav>
				</div>
				<nav id="header_menu_en" class="sp">
					<?php wp_nav_menu(array(
						'sort_column' => 'menu_order',
						'theme_location' => 'globalNavi_sp_en',
						'container' => '',
						'menu_id' => 'mobile_header_menu_en',
						'menu_class' => 'menu en'
					)); ?>
				</nav>
			</div>
		</header>
		<main>
			<?php if(is_front_page()) { ?>
				<?php } else  { ?>
					<div id="breadcrumb">
						<div class="inner clamp_breadcrumb" typeof="BreadcrumbList" vocab="https://schema.org/">
						<?php if(function_exists('bcn_display')) {
							bcn_display();
						} ?>
					</div>
				</div>
			<?php }; ?>